set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9019232';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0444323',
      0,
      0,
      2,
      0.687690,
      0.276676,
      NULL,
      NULL,
      4.467258,
      1,
      3.261065,
      0.681510,
      1.940027,
      NULL,
      1.301648,
      2,
      0,
      0.823948,
      0.301243,
      1,
      0,
      NULL,
      1,
      1.756917,
      3.125500,
      1,
      3.673401,
      1,
      0,
      0,
      2.851712,
      1.905576,
      0,
      NULL,
      0.688326,
      1,
      3,
      1.347893,
      1.615170,
      NULL,
      2.406905,
      1.963977,
      2,
      1.350360,
      1.540969,
      1,
      1,
      1.111319,
      NULL,
      0.527289,
      2.390310,
      0.734561,
      0,
      1,
      NULL,
      1,
      0.667667,
      0.769960,
      1.727688,
      2,
      3,
      1,
      NULL,
      1,
      1.819383,
      0,
      0.782656,
      0.196208,
      NULL,
      1,
      NULL,
      0,
      1,
      2.121733,
      1.492675,
      1,
      1.950497,
      NULL,
      0.890350,
      0.970952,
      1.675087,
      1.258103,
      0.548911,
      1,
      0.782105,
      1.754151,
      NULL,
      0.251814,
      NULL,
      0,
      0,
      1,
      2.190274,
      NULL,
      1.214806,
      0,
      1.738042,
      1.704715,
      1.921877,
      3,
      0,
      2.472088,
      NULL,
      1,
      0.894071,
      9.770993,
      4.988155,
      NULL,
      '',
      ' 4- 5-1986');
commit;
end;
/


