set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5803515';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3214113',
      1.885425,
      3,
      10.821597,
      NULL,
      NULL,
      NULL,
      5.091569,
      8,
      1.002734,
      NULL,
      NULL,
      NULL,
      3.149357,
      2.373790,
      1,
      NULL,
      1,
      1.774529,
      0,
      3.175702,
      0.165202,
      0,
      NULL,
      3.661507,
      1.577167,
      0.896914,
      3.000381,
      1,
      1,
      1.883997,
      0,
      NULL,
      1,
      3,
      1.013593,
      2.728895,
      1.743765,
      0,
      0.639017,
      2.891174,
      1,
      0.108083,
      NULL,
      NULL,
      1.612249,
      2,
      0,
      2,
      2,
      NULL,
      0,
      0,
      NULL,
      0.478538,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0.100469,
      1,
      1,
      0.831173,
      NULL,
      0,
      0,
      1.702113,
      0,
      2.731789,
      NULL,
      0,
      2,
      1,
      0.941514,
      1.148377,
      1,
      1.556904,
      1.495756,
      1,
      0,
      NULL,
      0.522171,
      1.423115,
      NULL,
      3.961631,
      1,
      NULL,
      0.775438,
      0,
      1.011921,
      0.015844,
      1,
      0.131266,
      NULL,
      1,
      0.185522,
      1.772127,
      3.238806,
      2.644770,
      2,
      0.829811,
      0,
      1.319406,
      2,
      4,
      '',
      '',
      NULL);
commit;
end;
/


