set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8321532';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0310302',
      NULL,
      0,
      34.414035,
      0,
      3,
      NULL,
      13.216311,
      18.467461,
      3,
      3.303125,
      1.715500,
      0.233937,
      0.888601,
      1.241111,
      3.874805,
      NULL,
      1,
      1.006509,
      2,
      3.296878,
      1.469945,
      NULL,
      NULL,
      0,
      3,
      3.436718,
      0.101886,
      2.975001,
      1.170750,
      NULL,
      NULL,
      NULL,
      3,
      2.497156,
      3,
      1,
      0.319734,
      0.076433,
      1.603351,
      NULL,
      1.788279,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      1,
      3.228914,
      1.799287,
      0,
      2,
      1.926031,
      0,
      NULL,
      3.192993,
      3.118461,
      NULL,
      0,
      1.093159,
      1.956936,
      2,
      1.236386,
      NULL,
      0.301137,
      3,
      0,
      1,
      2,
      1,
      2,
      NULL,
      1,
      2.583232,
      NULL,
      0,
      NULL,
      NULL,
      0.632456,
      2,
      1.532998,
      1.909695,
      1.576802,
      NULL,
      0.051925,
      0,
      NULL,
      0,
      NULL,
      1.663161,
      2.170250,
      1,
      1,
      NULL,
      1.200241,
      2.985990,
      0.571767,
      NULL,
      34.961084,
      29,
      NULL,
      '201',
      ' 5-28-1981');
commit;
end;
/


