set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3303202',
      NULL,
      3,
      14,
      1.708056,
      0.609555,
      4.283037,
      NULL,
      59.801461,
      NULL,
      3,
      0.760520,
      0.163829,
      0.739902,
      2,
      2.304606,
      NULL,
      1.901897,
      0.519031,
      0,
      1,
      NULL,
      NULL,
      0.898671,
      3.520330,
      0.381021,
      1.572949,
      1,
      NULL,
      1,
      0.383559,
      0,
      NULL,
      0.765775,
      0.543533,
      NULL,
      1.607022,
      1.577679,
      0,
      0.344908,
      NULL,
      NULL,
      2.378157,
      2.436619,
      1.642754,
      NULL,
      2.156308,
      0,
      NULL,
      0,
      2.628754,
      1.754407,
      1.523918,
      0.254096,
      0,
      0.946929,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      0.992708,
      1.367381,
      3.970756,
      0,
      1.512220,
      2,
      NULL,
      1,
      0.059915,
      0,
      NULL,
      3,
      NULL,
      0,
      1.643954,
      NULL,
      1,
      1.952539,
      0.455154,
      1.972107,
      NULL,
      1,
      1.686656,
      NULL,
      0.349419,
      NULL,
      NULL,
      0.863482,
      0,
      NULL,
      2,
      NULL,
      1,
      1,
      2.720379,
      0,
      1,
      3,
      NULL,
      0.649922,
      NULL,
      0.085109,
      3.271965,
      5.603734,
      '',
      NULL,
      ' 1- 8-1982');
commit;
end;
/


