set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6403762';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2.868579,
      2,
      NULL,
      3.680281,
      NULL,
      NULL,
      NULL,
      0.261203,
      1.922244,
      1.000016,
      3,
      2.713013,
      2,
      NULL,
      2.481920,
      NULL,
      NULL,
      1,
      0,
      1,
      1.417342,
      0,
      0,
      1.140139,
      1.151944,
      NULL,
      1,
      1.518868,
      1,
      2,
      1,
      0,
      1.434518,
      0.849622,
      1,
      0,
      0,
      0,
      1.886646,
      2,
      0,
      NULL,
      3.065360,
      3.658466,
      0,
      1.173077,
      0,
      NULL,
      1.690194,
      1,
      1,
      1.107905,
      1,
      1,
      1.907877,
      1,
      0.057178,
      1.249845,
      3,
      NULL,
      0.747989,
      0.369739,
      NULL,
      0,
      0.817133,
      3.353051,
      0.933831,
      0.119078,
      0,
      0.219235,
      1,
      0.186607,
      3,
      0,
      1,
      0,
      1.104755,
      NULL,
      0,
      NULL,
      1.454108,
      NULL,
      1.189400,
      0.142105,
      NULL,
      1.691774,
      0.676585,
      NULL,
      1.607752,
      0,
      1.990178,
      3,
      0.913181,
      0.534915,
      1,
      0.518069,
      1,
      NULL,
      0,
      2.344702,
      NULL,
      0.853647,
      1,
      1.777587,
      12.204372,
      NULL,
      '',
      '',
      ' 4- 6-1984');
commit;
end;
/


