set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9026436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2401123',
      1,
      3,
      26.164401,
      NULL,
      1,
      NULL,
      NULL,
      15,
      1,
      1,
      0.618390,
      1.909634,
      1,
      NULL,
      0,
      3,
      1,
      1,
      1,
      1.416540,
      1.705417,
      1.377090,
      0,
      2,
      0,
      NULL,
      1,
      1.746820,
      1,
      0.432445,
      0,
      1.601516,
      0,
      0.277956,
      0,
      3.588573,
      1,
      1,
      1.202239,
      NULL,
      3.840963,
      2,
      3.985434,
      1,
      1,
      3,
      0,
      0,
      0,
      0,
      1.210940,
      NULL,
      1,
      1,
      1.583336,
      1.350174,
      NULL,
      1,
      0,
      0.210550,
      1,
      NULL,
      0.576688,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.422717,
      0.588572,
      1.196866,
      1.024233,
      3,
      1.768913,
      0.490770,
      0.629490,
      1,
      0.258025,
      NULL,
      1.366117,
      2.096273,
      NULL,
      0,
      0,
      1.337258,
      1,
      1.754812,
      0.340312,
      0.593600,
      0.979075,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      1.938802,
      1,
      1.735688,
      NULL,
      NULL,
      1,
      1,
      0,
      6.083521,
      2.810859,
      '141',
      '413',
      NULL);
commit;
end;
/


