set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9114150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1002410',
      3,
      3,
      NULL,
      3.680828,
      0.825354,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.161283,
      2.535605,
      0.108248,
      0.934993,
      1.640867,
      2.335087,
      NULL,
      0.655628,
      NULL,
      NULL,
      1.480816,
      NULL,
      NULL,
      2.072824,
      0.753417,
      3,
      0,
      1.027902,
      0,
      2,
      0,
      1.618599,
      0.137917,
      1.573653,
      0.556417,
      2,
      1,
      NULL,
      0.753338,
      2.773855,
      0,
      2.331984,
      1,
      3.831881,
      0.048493,
      3,
      0,
      1,
      0,
      2.672463,
      1.243034,
      3,
      1,
      1,
      NULL,
      0.706899,
      1,
      1,
      3,
      1.079226,
      1.921005,
      0,
      NULL,
      0.253499,
      1.828636,
      3,
      NULL,
      NULL,
      NULL,
      2.974234,
      1.145130,
      1.827434,
      0.437193,
      0,
      0.061261,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.988467,
      0.070452,
      1.212166,
      0.525019,
      0,
      0.536242,
      1,
      1.144637,
      0.430408,
      NULL,
      0,
      0.341295,
      2,
      0.181453,
      1.354516,
      0,
      1,
      2,
      0.010507,
      1.337216,
      1,
      0,
      NULL,
      0,
      9.088761,
      0,
      '',
      '',
      ' 0-10-2003');
commit;
end;
/


