set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8735430';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2432041',
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.929690,
      1.415958,
      3,
      0.157135,
      3.446268,
      1.596775,
      1,
      NULL,
      0.019896,
      NULL,
      1.760304,
      0.499481,
      0.911498,
      1.116296,
      1,
      2.020603,
      NULL,
      3,
      1,
      NULL,
      1.086078,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.209208,
      NULL,
      0,
      0,
      2.635760,
      NULL,
      0.651128,
      NULL,
      0,
      2.504113,
      1,
      NULL,
      0,
      2.128022,
      0.848074,
      NULL,
      1.620064,
      1.504409,
      NULL,
      0,
      0.314154,
      0,
      2.050062,
      3.231021,
      1.600466,
      1.919807,
      0.356373,
      1,
      1.917356,
      0.332485,
      NULL,
      1.238649,
      0.649735,
      NULL,
      1.501330,
      0,
      2,
      0,
      1,
      3.773886,
      1.201869,
      1,
      1.375726,
      NULL,
      0,
      1,
      0.937424,
      NULL,
      1.620329,
      1.854991,
      1,
      1,
      NULL,
      0,
      1.436821,
      0.523871,
      1.793739,
      1,
      0,
      1,
      3.813212,
      0.611572,
      3,
      3.009083,
      0.054480,
      NULL,
      0.459142,
      0.187988,
      8,
      3,
      '',
      '',
      '11- 8-1982');
commit;
end;
/


