set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8707883';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4331020',
      2.097546,
      2,
      12,
      2.101423,
      1,
      NULL,
      NULL,
      31.937727,
      0.173367,
      3,
      NULL,
      NULL,
      2.987568,
      0,
      0.949480,
      2,
      1.382678,
      1,
      1.886503,
      1,
      1,
      2,
      NULL,
      1,
      0,
      3,
      0.666106,
      NULL,
      1.072252,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      0.313191,
      0.276968,
      NULL,
      1,
      NULL,
      0,
      0.566126,
      3,
      1.298461,
      0,
      NULL,
      0,
      NULL,
      1.709963,
      2.883080,
      0,
      0.707598,
      0.034226,
      0,
      1.689088,
      0,
      1.459696,
      1.579148,
      1.706798,
      1.654510,
      0,
      NULL,
      NULL,
      NULL,
      0.310018,
      2.925961,
      0.307908,
      1.995163,
      0.658753,
      NULL,
      0,
      NULL,
      3.300650,
      3.115891,
      1.893676,
      0,
      0.321013,
      NULL,
      0,
      1,
      0.045277,
      0,
      0.749712,
      0.042186,
      1.452728,
      1.277648,
      0.351268,
      3.270571,
      0.071232,
      NULL,
      0,
      3,
      3,
      1.119097,
      0,
      1.465367,
      NULL,
      0,
      2,
      1.839350,
      0.647268,
      0,
      2.909385,
      1,
      2.199493,
      0,
      '',
      '',
      ' 0-22-1989');
commit;
end;
/


