set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7728019';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2000341',
      0,
      2,
      4.827688,
      2.642257,
      0.607679,
      NULL,
      NULL,
      23.931075,
      0.452347,
      2.772212,
      0,
      1.143475,
      NULL,
      1.547418,
      0,
      2,
      1.001395,
      0.847928,
      1.774673,
      0.353022,
      0.194915,
      2,
      0.555040,
      1,
      NULL,
      1,
      0,
      1,
      1.746054,
      1,
      NULL,
      1,
      0.748946,
      NULL,
      0,
      0.940012,
      1.969930,
      1,
      1.186805,
      0,
      1.885893,
      3.708454,
      3.027378,
      3.360527,
      0,
      1,
      0.893999,
      0.738541,
      1.925071,
      1.220652,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      0.076003,
      2,
      2.221043,
      NULL,
      NULL,
      0,
      0.280383,
      1.318669,
      1.245980,
      NULL,
      NULL,
      1.391987,
      0,
      1.884844,
      0,
      3,
      0,
      NULL,
      2,
      0.972959,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.718536,
      NULL,
      0.799510,
      0,
      0,
      1.915529,
      0,
      1.542801,
      1.505879,
      1.031732,
      3,
      0.813879,
      1.239421,
      0,
      NULL,
      0.580999,
      1,
      2.297479,
      0,
      3,
      NULL,
      0,
      4,
      5.313853,
      '',
      NULL,
      ' 8- 3-1989');
commit;
end;
/


