set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2442142',
      NULL,
      NULL,
      NULL,
      0.807153,
      NULL,
      0.945833,
      NULL,
      18.197413,
      1.944033,
      0.662259,
      NULL,
      3.717738,
      3,
      0.122428,
      1,
      0.168984,
      NULL,
      0,
      3,
      1,
      0,
      1,
      0.431612,
      2.680836,
      0.143259,
      0,
      1,
      0.135836,
      0.233894,
      2.657036,
      0,
      2.971263,
      NULL,
      0.347004,
      0.191520,
      2.318383,
      NULL,
      1.624305,
      1,
      2.355101,
      2,
      0,
      1,
      NULL,
      1,
      3,
      0.526974,
      1.681597,
      0.110387,
      2.142362,
      1.431452,
      0.177916,
      1,
      3,
      NULL,
      0.607480,
      1.033025,
      NULL,
      NULL,
      0,
      0.692971,
      1.488588,
      0.772414,
      NULL,
      0.983574,
      1.511647,
      NULL,
      0,
      NULL,
      0,
      1.507893,
      NULL,
      3.120601,
      NULL,
      0,
      0,
      NULL,
      0,
      1.154204,
      0,
      1.459897,
      1,
      1.709119,
      0,
      NULL,
      1,
      1.704401,
      1,
      1.041232,
      NULL,
      3.747165,
      0.577920,
      3.006666,
      0.036032,
      NULL,
      1,
      3.703100,
      2,
      1.110445,
      0,
      NULL,
      1.485582,
      2.106401,
      1.072750,
      9,
      1.394976,
      '',
      '',
      NULL);
commit;
end;
/


