set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8132604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2102230',
      0.285257,
      2,
      NULL,
      3.578529,
      NULL,
      4.326877,
      50,
      99,
      2.483939,
      1.970719,
      3,
      0,
      0.286827,
      0.872822,
      NULL,
      NULL,
      2,
      0.147377,
      0.196307,
      NULL,
      3,
      3,
      1,
      NULL,
      NULL,
      1.944200,
      2,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      2,
      NULL,
      3.780395,
      3.453053,
      NULL,
      1,
      3,
      2,
      0.058025,
      0.068431,
      2,
      1,
      NULL,
      0,
      NULL,
      2,
      NULL,
      3.675340,
      1.030903,
      0,
      0.113272,
      NULL,
      0.368903,
      1,
      1,
      0,
      3,
      1,
      1.513242,
      1,
      2.071075,
      0.947516,
      NULL,
      0,
      3.608388,
      1,
      3.539641,
      3,
      3,
      3,
      2,
      1.506856,
      NULL,
      3,
      2,
      2.604243,
      3,
      0.168582,
      1.964712,
      NULL,
      1,
      0.659810,
      1,
      NULL,
      3.288377,
      0.742412,
      2,
      NULL,
      NULL,
      0.963201,
      0,
      1,
      1.517444,
      1.478223,
      0,
      0.629956,
      NULL,
      0.439950,
      3,
      0.276734,
      0,
      27.316994,
      18,
      '301',
      '031',
      '11-23-1996');
commit;
end;
/


