set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4002141',
      2,
      2,
      NULL,
      2.610158,
      NULL,
      3.939582,
      NULL,
      37.982066,
      0.426121,
      2.597395,
      1.735568,
      1.070207,
      1.124396,
      1.342663,
      1.535796,
      2,
      NULL,
      NULL,
      2,
      1,
      1,
      3,
      0,
      3.831865,
      0.988725,
      NULL,
      1,
      0.040423,
      1.389774,
      NULL,
      0,
      0,
      0,
      0,
      1.191277,
      1.882466,
      NULL,
      0,
      0,
      2,
      3.301707,
      NULL,
      2,
      2.551873,
      NULL,
      1.847750,
      1,
      0.650102,
      0.932534,
      2.082765,
      0.299969,
      NULL,
      NULL,
      0,
      0.477873,
      1,
      NULL,
      0.149652,
      NULL,
      3,
      0,
      NULL,
      0.109979,
      2,
      1,
      1,
      NULL,
      NULL,
      1.248392,
      0,
      0,
      1,
      NULL,
      1.163687,
      1.614041,
      0.223107,
      NULL,
      0.622794,
      1.717217,
      NULL,
      NULL,
      NULL,
      0.172256,
      1.013281,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.139385,
      1,
      1,
      0.476478,
      0,
      NULL,
      NULL,
      NULL,
      1.601300,
      0.408154,
      NULL,
      2,
      2.225403,
      NULL,
      0,
      5.231244,
      0,
      '',
      '',
      ' 8-12-1982');
commit;
end;
/


