set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8801751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0412210',
      3.883755,
      2,
      21.856338,
      2.596835,
      0.292898,
      NULL,
      NULL,
      59,
      1,
      1,
      1.943651,
      0.736199,
      1,
      0.561357,
      0.373662,
      NULL,
      0.596445,
      0.265267,
      NULL,
      1.046207,
      0,
      1.071536,
      1,
      3,
      NULL,
      NULL,
      1,
      0,
      1.253104,
      NULL,
      1.535813,
      1.055127,
      0.670286,
      0.684753,
      1,
      NULL,
      1,
      1.142125,
      NULL,
      3.904475,
      2.324114,
      0.838441,
      2,
      3.604572,
      1,
      NULL,
      1,
      3.855857,
      0.447198,
      1,
      1.517301,
      0.796973,
      1,
      1.374989,
      1,
      0,
      1.951839,
      1.315028,
      NULL,
      NULL,
      NULL,
      0.364646,
      0.427245,
      1.422703,
      NULL,
      1,
      0.178389,
      2,
      NULL,
      NULL,
      1.739981,
      0,
      0.287159,
      3,
      0,
      0,
      NULL,
      NULL,
      0,
      1.984366,
      NULL,
      1,
      1,
      0.442723,
      1,
      1.879764,
      0.694050,
      1.594431,
      NULL,
      1.032766,
      1.564668,
      3.627242,
      2.467217,
      1,
      1,
      1.045799,
      2.318023,
      0.734342,
      0,
      2.490811,
      0.166878,
      0.547910,
      1.475085,
      0,
      0.268991,
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


