set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8614836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1402111',
      3,
      2,
      24.939556,
      2.569108,
      3,
      0,
      45.719868,
      1,
      0.584069,
      1.875591,
      1.161018,
      3,
      3,
      0.362430,
      1,
      3.429203,
      NULL,
      0,
      2,
      0.985522,
      1.124917,
      2,
      1,
      0,
      0.760219,
      3,
      1,
      1,
      1,
      1.983102,
      0.322862,
      NULL,
      NULL,
      0,
      1.393672,
      2,
      1,
      1,
      NULL,
      NULL,
      0.145394,
      1,
      0.355806,
      1,
      1,
      0.597459,
      1.588235,
      2,
      1,
      1.700514,
      1,
      NULL,
      0.235363,
      0.716356,
      1,
      NULL,
      0,
      0.807547,
      0,
      0.707610,
      0,
      0.398422,
      1,
      NULL,
      NULL,
      2,
      1.300053,
      0.514857,
      0,
      1,
      0.989575,
      2,
      1.291535,
      3.693252,
      0.571638,
      2,
      1,
      0,
      0.855016,
      1.690203,
      NULL,
      1,
      NULL,
      1.697459,
      0.800145,
      NULL,
      NULL,
      NULL,
      0.073368,
      0,
      0,
      NULL,
      3.867235,
      1.492411,
      1,
      1,
      1,
      1.718784,
      3.373437,
      3,
      3.955744,
      2.559457,
      2,
      1.910302,
      2.380766,
      5.716115,
      NULL,
      '',
      '10-18-2000');
commit;
end;
/


