set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9304467';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4224123',
      0,
      2,
      NULL,
      NULL,
      1.509716,
      NULL,
      NULL,
      17.591562,
      1,
      2.870384,
      NULL,
      3.192686,
      3,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      0.057824,
      1.815398,
      3,
      1,
      NULL,
      NULL,
      0.024318,
      0,
      0,
      NULL,
      3.509117,
      1.151923,
      0.888669,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2.982280,
      0,
      3,
      NULL,
      NULL,
      1,
      1.563537,
      0,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      1.156824,
      0,
      0,
      3,
      3.522941,
      2,
      1.491706,
      0,
      0.454734,
      0.400162,
      1,
      2.635564,
      0.001931,
      1.280756,
      1.320673,
      NULL,
      1,
      NULL,
      0.880773,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      NULL,
      1.977615,
      NULL,
      0,
      0,
      NULL,
      2,
      NULL,
      1.291323,
      0,
      0.431662,
      0.257117,
      3.843535,
      3,
      1.517442,
      0.057879,
      0.889542,
      0,
      1.672422,
      2,
      1.841956,
      2.373049,
      3.682432,
      NULL,
      NULL,
      6.864329,
      NULL,
      '032',
      '401',
      NULL);
commit;
end;
/


