set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902034';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0220401',
      2,
      2,
      12,
      1,
      3.391540,
      NULL,
      NULL,
      22.498439,
      0.753059,
      0,
      0,
      2,
      1.211255,
      0.045305,
      3,
      3.231142,
      NULL,
      0.077967,
      0,
      1,
      1.181968,
      1.880725,
      1.184967,
      2.050393,
      1,
      1.191955,
      0,
      1,
      NULL,
      2,
      0,
      1.613979,
      0,
      NULL,
      NULL,
      2,
      0,
      1.176822,
      1.072733,
      0,
      3.565874,
      2.668298,
      NULL,
      1,
      1.555329,
      2,
      NULL,
      1.197917,
      NULL,
      3.937882,
      0.961742,
      1.634230,
      1,
      0,
      0,
      1.256174,
      NULL,
      0.781871,
      3.319213,
      0,
      0.205449,
      1.335548,
      1.439448,
      1,
      1.528578,
      3.107731,
      1.688990,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0.851116,
      0,
      1,
      0.723507,
      0.177193,
      1,
      NULL,
      1,
      0.333914,
      1.652708,
      NULL,
      0,
      1.309871,
      NULL,
      0,
      0,
      0.240432,
      0,
      NULL,
      3.182792,
      0.559261,
      1.922889,
      0,
      3.168922,
      1.041179,
      3.349267,
      2,
      0,
      2,
      0.502818,
      1.916847,
      6,
      2.638464,
      '',
      NULL,
      ' 9-29-1986');
commit;
end;
/


