set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8912432';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4413121',
      0.779010,
      3,
      28,
      3,
      NULL,
      NULL,
      23.327537,
      63.007522,
      NULL,
      1.696322,
      2,
      2,
      1,
      1.951087,
      0,
      1.800540,
      1.083762,
      1.231622,
      0.374979,
      1,
      1,
      2.447866,
      1.002433,
      0.289500,
      0,
      2,
      0.636250,
      1,
      0,
      2,
      0.965093,
      0.644151,
      1,
      NULL,
      NULL,
      1.742602,
      1,
      0.840105,
      1,
      1.945368,
      0.897304,
      2.082596,
      2.414430,
      3.345609,
      1,
      2.601693,
      1.912390,
      1,
      NULL,
      0,
      1.726427,
      0.989527,
      0,
      1.971825,
      NULL,
      NULL,
      1.438785,
      NULL,
      0.315981,
      NULL,
      NULL,
      0.970798,
      1.088038,
      1,
      0.592778,
      1,
      0.359659,
      1.369126,
      1.050694,
      1.852444,
      NULL,
      0.332098,
      1.239855,
      1,
      NULL,
      1.821384,
      NULL,
      0,
      1.749102,
      0,
      0.981607,
      1,
      0,
      0.918721,
      0,
      0,
      1,
      0.938503,
      NULL,
      1.406046,
      1.464996,
      1.432376,
      NULL,
      0,
      0,
      0.608568,
      0,
      1.654960,
      0,
      NULL,
      1.917178,
      2.501831,
      3,
      0,
      0,
      NULL,
      '',
      '',
      ' 7-20-1991');
commit;
end;
/


