set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9416746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4231140',
      2,
      NULL,
      11,
      2,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.586475,
      1.869356,
      3.099093,
      NULL,
      0.655334,
      NULL,
      0.593343,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1.790264,
      0,
      0.167474,
      NULL,
      0,
      1.521731,
      NULL,
      2.260963,
      0.502199,
      NULL,
      1.169339,
      NULL,
      NULL,
      0.477150,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      0.585111,
      NULL,
      1,
      1,
      2,
      0.872246,
      NULL,
      0,
      1,
      1,
      1,
      1.652486,
      0,
      0,
      1,
      3.460051,
      2.363925,
      0,
      0.567973,
      1,
      0.407481,
      1.194007,
      3.363312,
      NULL,
      NULL,
      0,
      0,
      1.294065,
      1,
      1.422189,
      1,
      0.212264,
      0.331602,
      NULL,
      NULL,
      1,
      0,
      1.032245,
      0,
      0.929881,
      1.349873,
      0,
      0,
      NULL,
      0,
      1,
      1,
      0.984654,
      0.432056,
      1.759427,
      1,
      1,
      0,
      1.789632,
      1.138376,
      0.215677,
      NULL,
      0,
      2,
      3.853481,
      0,
      4,
      NULL,
      '140',
      '22',
      ' 3- 6-1999');
commit;
end;
/


