set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8927646';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3122011',
      3,
      0,
      7,
      1,
      1,
      NULL,
      NULL,
      40.065590,
      0.071777,
      1,
      0.505826,
      2.241656,
      0,
      0,
      1.037265,
      1,
      0,
      0,
      3,
      1,
      NULL,
      1.124742,
      1.547689,
      3,
      1,
      1,
      1,
      0.165657,
      1,
      0,
      1.067679,
      0.877251,
      1.659186,
      0,
      1.857252,
      3,
      0.445381,
      NULL,
      1,
      0.037325,
      NULL,
      NULL,
      3,
      1.904977,
      0,
      0.506686,
      3,
      0,
      0,
      2,
      1,
      NULL,
      1.196763,
      1.919891,
      NULL,
      0,
      0.717265,
      0.242002,
      3.759451,
      NULL,
      0,
      0,
      0,
      NULL,
      1.014267,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.007180,
      2,
      0,
      NULL,
      NULL,
      0.111040,
      1.197449,
      1,
      NULL,
      0.271996,
      0,
      NULL,
      0,
      1.127361,
      1,
      1,
      1,
      1.128193,
      0.431960,
      NULL,
      NULL,
      1.190361,
      1,
      0.308168,
      0,
      3.602083,
      2.724961,
      NULL,
      1.046167,
      2.479363,
      2,
      NULL,
      3,
      4,
      NULL,
      '',
      '10-19-1994');
commit;
end;
/


