set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000064';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1413121',
      1,
      0,
      29,
      NULL,
      1,
      0,
      2.405352,
      NULL,
      1,
      3,
      2.868081,
      1.358620,
      3.239897,
      1,
      2,
      0,
      0.999930,
      1,
      NULL,
      0,
      0,
      2,
      NULL,
      1.979316,
      0.928519,
      1.772930,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.269331,
      1,
      0.243218,
      1,
      0,
      1.397071,
      NULL,
      0,
      0.036413,
      1,
      3.761099,
      1.404852,
      1.189126,
      NULL,
      1,
      NULL,
      0.814515,
      0.007078,
      1,
      0.117062,
      1,
      1,
      1.145664,
      1.861678,
      1,
      3.358458,
      1.941961,
      0,
      0,
      0,
      1,
      2.765646,
      1.957016,
      3.599902,
      NULL,
      0.465810,
      1.716663,
      2.069664,
      0.078127,
      0,
      1,
      2.241154,
      1,
      0,
      0.779681,
      1,
      0,
      0,
      1,
      0.526037,
      1,
      0.645970,
      0.707050,
      0.887377,
      0.045543,
      0.974481,
      NULL,
      NULL,
      1,
      0.696608,
      1.669575,
      0.873271,
      0,
      1,
      0.930100,
      1.683491,
      2.253772,
      1,
      0,
      3.795003,
      1.899464,
      1.361407,
      NULL,
      5,
      '',
      '',
      ' 3- 0-2003');
commit;
end;
/


