set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6607548';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3044014',
      3.590022,
      2,
      NULL,
      3.404399,
      0.863028,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      0.070646,
      NULL,
      1.042208,
      1.066489,
      NULL,
      NULL,
      1.987432,
      1.985949,
      2.304818,
      0.813720,
      NULL,
      3,
      1,
      0,
      0,
      3.382427,
      0,
      0,
      NULL,
      1.469256,
      NULL,
      1.239185,
      0,
      1.728901,
      1,
      2,
      1,
      NULL,
      1.566952,
      NULL,
      NULL,
      1.462038,
      1,
      2,
      0,
      3,
      0.595991,
      0.710376,
      NULL,
      0,
      1,
      0.769720,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.859932,
      3.229518,
      2.032499,
      1.441687,
      0.353073,
      0,
      0.216935,
      1,
      3,
      0,
      0.252404,
      1.675372,
      NULL,
      NULL,
      0,
      0.464668,
      2,
      1.648270,
      0,
      1,
      0,
      NULL,
      1.792951,
      1.835879,
      0,
      0.860257,
      0,
      0,
      1.609244,
      0.056136,
      NULL,
      1,
      1,
      0.097323,
      0.743114,
      1,
      1.792541,
      NULL,
      0.095369,
      3,
      1.810695,
      NULL,
      2.483889,
      2,
      2,
      NULL,
      0,
      16.523052,
      NULL,
      '104',
      NULL,
      ' 9-12-1995');
commit;
end;
/


