set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8226743';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2331133',
      NULL,
      NULL,
      16.230085,
      NULL,
      0,
      NULL,
      NULL,
      26,
      NULL,
      NULL,
      1,
      2.157543,
      2,
      3,
      NULL,
      1,
      0.822204,
      0.155287,
      3.977927,
      1,
      0.433917,
      0.308845,
      0,
      3,
      NULL,
      2.522261,
      1,
      0.260187,
      NULL,
      NULL,
      1,
      1,
      0,
      0.538445,
      1,
      2,
      0.146786,
      1.251927,
      1.102061,
      2.602188,
      3,
      0.965527,
      3.589654,
      0.518523,
      1,
      0,
      1.248950,
      0.270717,
      0,
      2,
      1.610659,
      0.492163,
      NULL,
      3,
      1.549741,
      NULL,
      0,
      0.773171,
      2.150121,
      NULL,
      1,
      0.352274,
      NULL,
      NULL,
      1.753822,
      1,
      1,
      0.386999,
      0.378483,
      0.114126,
      0.930377,
      1.137163,
      0.055832,
      NULL,
      1,
      2,
      0,
      0.264361,
      NULL,
      NULL,
      0.592860,
      0,
      NULL,
      NULL,
      1.413413,
      0.938880,
      0,
      NULL,
      NULL,
      0.864684,
      2,
      NULL,
      2.855401,
      0.933320,
      0.269177,
      1,
      2.953840,
      NULL,
      2.962621,
      3.933044,
      1.191817,
      1,
      0.405190,
      0,
      2,
      3,
      '',
      '',
      ' 3-18-1979');
commit;
end;
/


