set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000179';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      1,
      3.391965,
      1.285495,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      2.231019,
      3,
      2.772809,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.604486,
      0,
      0,
      0.925236,
      3,
      1.491091,
      NULL,
      0,
      NULL,
      0,
      1.935833,
      0.190551,
      1,
      NULL,
      NULL,
      0,
      0,
      0.762521,
      1.811455,
      1,
      0.477164,
      2.188260,
      3,
      0.953091,
      3,
      NULL,
      NULL,
      0.805685,
      1.825350,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.388506,
      0,
      NULL,
      0.451976,
      3.682234,
      1.884528,
      NULL,
      0,
      0.931684,
      1.509219,
      0.710477,
      0,
      1.686724,
      1.259288,
      1,
      0.001466,
      1.031958,
      1.785902,
      1,
      1.651086,
      NULL,
      1.603968,
      1.836598,
      1,
      1.955126,
      0,
      0.374681,
      0.255198,
      0,
      0.880777,
      0.911315,
      0.945579,
      0.633311,
      1.318434,
      NULL,
      1.316161,
      0.079604,
      0.043073,
      1.315246,
      0.416906,
      0.794441,
      NULL,
      NULL,
      0,
      2,
      1.500090,
      0.249008,
      1,
      2.978557,
      1,
      8.088621,
      0.970445,
      '',
      NULL,
      '10- 4-1989');
commit;
end;
/


