set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329209';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0.124238,
      2,
      NULL,
      0.465020,
      0,
      NULL,
      NULL,
      33.759823,
      NULL,
      0,
      0,
      3.491076,
      2,
      0,
      1,
      2.922708,
      1.769401,
      1.877366,
      3.314341,
      0.641822,
      0.510162,
      1,
      1.745348,
      3,
      1.440565,
      1,
      0.290003,
      NULL,
      0,
      3,
      1.534653,
      1.164178,
      1.407742,
      0.785026,
      NULL,
      3.091611,
      1,
      2.593829,
      1.289551,
      3.398110,
      0.992532,
      3.323924,
      NULL,
      NULL,
      1.782633,
      NULL,
      1,
      0,
      0.546116,
      2,
      0,
      1.689313,
      0,
      1,
      1.839506,
      NULL,
      1.981054,
      1,
      NULL,
      NULL,
      1.555988,
      1.823054,
      NULL,
      2,
      1,
      2,
      0,
      1.324953,
      1.747004,
      1,
      1,
      1,
      0,
      0.612037,
      0.265401,
      0.720745,
      1.753373,
      0,
      0,
      1.594728,
      NULL,
      1.382246,
      0,
      1,
      0,
      1.936095,
      1.779503,
      NULL,
      1,
      0,
      0.481770,
      1,
      NULL,
      1.996369,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      3.489930,
      1,
      NULL,
      2,
      NULL,
      4,
      '011',
      '42',
      ' 0-17-1992');
commit;
end;
/


