set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000140';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4210402',
      0,
      3,
      NULL,
      2,
      2,
      1,
      22.569736,
      49,
      1,
      NULL,
      1.242443,
      0,
      3,
      0,
      0,
      1.949548,
      0,
      0.232139,
      2.908717,
      1.251841,
      0,
      1.531395,
      0,
      0,
      0,
      3.931044,
      1,
      NULL,
      NULL,
      NULL,
      1.911892,
      1.755239,
      0,
      0,
      1.418843,
      3.822668,
      0.286633,
      NULL,
      0,
      3,
      0.997117,
      1,
      1,
      0.239604,
      0.649235,
      2,
      0,
      2,
      0,
      3,
      0,
      NULL,
      0,
      1,
      1,
      1.666526,
      1,
      1.203983,
      1.386807,
      0.239645,
      1.140850,
      1,
      0.738637,
      0,
      NULL,
      1.142449,
      1,
      0,
      1,
      0.645039,
      0.928711,
      0,
      2,
      0,
      1.312160,
      1.863328,
      0.419972,
      1,
      1,
      NULL,
      1.069132,
      1,
      1.702862,
      NULL,
      1,
      0.687002,
      1,
      NULL,
      NULL,
      0.758368,
      NULL,
      0.933693,
      0.876518,
      1,
      1.108068,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.507709,
      3.169959,
      '',
      '',
      ' 0- 9-1974');
commit;
end;
/


