set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4432324',
      NULL,
      3,
      30.189336,
      1,
      0.298094,
      1,
      NULL,
      NULL,
      0.863254,
      0,
      0,
      NULL,
      2,
      0.298777,
      1.573970,
      3,
      1.453333,
      NULL,
      3,
      1,
      1,
      0,
      0,
      1.201392,
      0,
      0,
      0.499059,
      NULL,
      0,
      0.965342,
      1.790298,
      1,
      NULL,
      0,
      1.983151,
      0,
      1,
      0.824700,
      1.091468,
      NULL,
      0.170264,
      2.715613,
      1,
      1.879344,
      0,
      0,
      1,
      0.723864,
      0,
      NULL,
      0,
      0.331705,
      1.842016,
      0,
      NULL,
      1.109858,
      1.680124,
      NULL,
      0,
      NULL,
      0.170271,
      NULL,
      1,
      1,
      1.954129,
      0,
      0,
      3,
      1.121876,
      1,
      0,
      0,
      2,
      3.838129,
      NULL,
      1.985427,
      0,
      0.713148,
      1,
      0,
      1,
      1.404613,
      0,
      1.242114,
      0,
      1,
      1,
      0.473710,
      0,
      1,
      1,
      0,
      3.133963,
      NULL,
      NULL,
      0.577201,
      NULL,
      1.017969,
      NULL,
      2,
      3,
      1,
      0.673125,
      1,
      1,
      0,
      NULL,
      NULL,
      ' 5-28-1977');
commit;
end;
/


