set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906642';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2432132',
      0,
      NULL,
      NULL,
      0,
      2.072572,
      3,
      18,
      34.335931,
      1,
      2.502072,
      1,
      0,
      2.854502,
      1.310759,
      NULL,
      1,
      0,
      2.359061,
      NULL,
      0,
      NULL,
      1,
      1,
      2.695071,
      0.200257,
      1,
      0.471013,
      3.102665,
      2.890555,
      1.372989,
      1,
      NULL,
      3.012496,
      0,
      1.143181,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      1,
      1.916168,
      0,
      0.489705,
      0.768366,
      2.588399,
      0,
      0,
      NULL,
      NULL,
      0.754114,
      NULL,
      NULL,
      0,
      3,
      1,
      3.079100,
      1,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0.873423,
      0.990389,
      1.659183,
      NULL,
      0.653221,
      1,
      2.199453,
      1.242106,
      1,
      1.251517,
      0.375548,
      0.455025,
      NULL,
      2,
      2.482030,
      1.455853,
      3.105510,
      3.337237,
      3,
      1,
      2.422640,
      NULL,
      1,
      0,
      0,
      0.019171,
      1,
      2,
      1,
      0,
      NULL,
      3.379921,
      0,
      1.217719,
      0,
      3,
      NULL,
      0.775416,
      NULL,
      33.513520,
      19,
      '',
      '',
      ' 0-17-1984');
commit;
end;
/


