set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000115';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2434214',
      0,
      1,
      27,
      2,
      3,
      0.200998,
      12,
      NULL,
      1,
      0,
      2.457513,
      1,
      1.888145,
      0,
      0,
      1.509080,
      1.699249,
      1.630208,
      1,
      1.979420,
      1.038106,
      1.990403,
      0.585616,
      0.618085,
      NULL,
      0,
      1.753681,
      1,
      0.040244,
      0.041591,
      NULL,
      0.195278,
      0,
      NULL,
      0,
      2,
      NULL,
      0,
      1.853147,
      1,
      1.186021,
      0,
      2,
      3,
      1.192411,
      0,
      1.510592,
      3.259647,
      NULL,
      1,
      0,
      1.955926,
      1.275839,
      1,
      1.160894,
      1.226555,
      0,
      0.460730,
      3.564734,
      NULL,
      1,
      1.133401,
      1,
      1,
      1,
      0,
      1.295427,
      2.147880,
      0.416722,
      NULL,
      1.943371,
      1.504829,
      1.005619,
      1.193964,
      1.147225,
      1,
      1,
      0,
      NULL,
      1.961700,
      1,
      1,
      2,
      0,
      1,
      1,
      NULL,
      0.764161,
      NULL,
      1.876373,
      0.778887,
      NULL,
      NULL,
      0,
      2.691001,
      0.178448,
      0,
      1.770889,
      1.286027,
      1.473055,
      3.613606,
      1,
      0.393446,
      0,
      16,
      5.580964,
      '',
      '',
      ' 8- 1-1987');
commit;
end;
/


