set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000193';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2430204',
      NULL,
      1,
      1,
      NULL,
      1.683236,
      NULL,
      2.702988,
      NULL,
      0.796786,
      0,
      NULL,
      NULL,
      0.907856,
      1,
      1.973272,
      0,
      NULL,
      1.516705,
      0,
      1,
      1.138824,
      3.905577,
      NULL,
      NULL,
      0,
      3.048501,
      0.585209,
      1,
      1,
      3,
      1,
      1.344206,
      1.434360,
      1.269458,
      NULL,
      0.395048,
      1.993944,
      1,
      NULL,
      1,
      1.794270,
      NULL,
      1,
      NULL,
      1.180673,
      0,
      1.754987,
      NULL,
      1,
      NULL,
      0,
      1.969239,
      0.514085,
      1.172480,
      0.226868,
      0.121156,
      0,
      1,
      1.793066,
      1.398280,
      1.880718,
      0.993645,
      1.045584,
      1.793317,
      0.181607,
      NULL,
      0,
      0.325192,
      0.016383,
      0.285456,
      1.290490,
      1.348704,
      3.782073,
      2.534195,
      NULL,
      1,
      NULL,
      1.680202,
      0.124070,
      NULL,
      0.800765,
      0.029079,
      NULL,
      0.278804,
      1.261578,
      1,
      1,
      NULL,
      0,
      0.919232,
      NULL,
      0,
      1.977159,
      1.362186,
      0,
      1.195161,
      1,
      0.878134,
      0.040694,
      NULL,
      1.969567,
      0,
      0.108078,
      3.427995,
      19,
      1.591202,
      '',
      '',
      ' 7-14-1983');
commit;
end;
/


