set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6103247';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4202224',
      NULL,
      0,
      10.729055,
      1.828068,
      2.119458,
      4,
      53.409793,
      59,
      1,
      0.817408,
      2.494255,
      3.345811,
      3,
      0,
      0.435438,
      NULL,
      0.366242,
      NULL,
      3.978318,
      0,
      NULL,
      2.285570,
      1,
      0.919658,
      0.567485,
      NULL,
      1.717332,
      0,
      0,
      3,
      1,
      0.082009,
      0,
      0,
      1,
      1,
      0,
      0,
      1.897530,
      3,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      0,
      1.325153,
      0,
      NULL,
      0.194677,
      1,
      0,
      0,
      0.479812,
      0,
      NULL,
      0.794468,
      0.650746,
      1,
      1,
      0.828901,
      0,
      1,
      0,
      NULL,
      0.513869,
      2.765877,
      1,
      1,
      1.499497,
      0.703809,
      2,
      0,
      1.646764,
      0.010366,
      1,
      1.406045,
      NULL,
      0.777752,
      1.145403,
      1,
      1.215452,
      NULL,
      1.869842,
      1.285102,
      1,
      1.091764,
      0,
      0.373910,
      NULL,
      1.429020,
      NULL,
      NULL,
      NULL,
      1.172384,
      0.948435,
      0.054962,
      0,
      1.096268,
      2.902167,
      2,
      3,
      1.957945,
      4,
      0.183986,
      '',
      '',
      '11-28-1981');
commit;
end;
/


