set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8612313';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4323141',
      1.690409,
      1,
      16,
      0.556286,
      0,
      NULL,
      NULL,
      42,
      0.315796,
      NULL,
      0.988480,
      0,
      0.693599,
      0.271977,
      3.249811,
      2,
      1.087094,
      0.915875,
      2,
      1.990901,
      0,
      2,
      1.546943,
      0.185763,
      0.566020,
      1,
      1.045903,
      3,
      0,
      2,
      0.636409,
      1,
      NULL,
      NULL,
      0.466812,
      2,
      1,
      1.221478,
      1.106254,
      3,
      1,
      2.154429,
      NULL,
      3.602582,
      NULL,
      3.893749,
      1,
      1,
      1.810755,
      0.413667,
      0,
      0.522821,
      1,
      1.288705,
      1.706062,
      2,
      NULL,
      0.341572,
      0.374581,
      0,
      1.457948,
      1.694908,
      2.635789,
      2,
      0.588205,
      1,
      NULL,
      1.402028,
      1.619012,
      0.761381,
      NULL,
      0,
      0,
      3,
      0,
      0,
      0,
      2.710018,
      0.338242,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      3,
      1.051215,
      NULL,
      0.002121,
      1,
      NULL,
      2.007441,
      1.477160,
      0.816054,
      1,
      NULL,
      0.293758,
      1.135830,
      1,
      NULL,
      2.370899,
      2.184304,
      2.846483,
      1,
      11.196417,
      9.226281,
      NULL,
      '104',
      ' 7- 7-2002');
commit;
end;
/


