set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000109';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      3.863832,
      3,
      12.312776,
      2,
      2,
      NULL,
      2,
      39,
      0,
      0.294331,
      1,
      3,
      3.511887,
      1.888758,
      3,
      1,
      NULL,
      0.827215,
      NULL,
      NULL,
      1.950766,
      2.937740,
      0.053460,
      NULL,
      1.985445,
      NULL,
      1,
      NULL,
      1.129811,
      NULL,
      1,
      NULL,
      0.032909,
      1.762157,
      1,
      NULL,
      0.002988,
      1,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      0.861031,
      2,
      NULL,
      2.903757,
      0,
      2.303556,
      0.118486,
      1.444962,
      1.966449,
      0.021358,
      1.389545,
      NULL,
      0.170449,
      1,
      1,
      0.880441,
      NULL,
      0,
      1.490357,
      1.042700,
      1,
      1,
      NULL,
      3,
      NULL,
      0,
      1,
      0.955006,
      1.187369,
      3,
      1.276238,
      3,
      1,
      0.629547,
      0,
      NULL,
      1.931492,
      NULL,
      NULL,
      1.523476,
      1,
      0.618639,
      NULL,
      1,
      NULL,
      1,
      0.185587,
      NULL,
      NULL,
      NULL,
      3.579373,
      NULL,
      1,
      1,
      NULL,
      1.122339,
      NULL,
      2.607339,
      1,
      0.550220,
      12,
      2.897371,
      '',
      '',
      NULL);
commit;
end;
/


