set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8910497';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2410133',
      0.603282,
      1,
      NULL,
      2.237568,
      0,
      NULL,
      NULL,
      NULL,
      1.838493,
      1.300295,
      0,
      0,
      2,
      1.421160,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.003423,
      2,
      1,
      1,
      1,
      NULL,
      0,
      3.123889,
      1.479769,
      0.249296,
      1.829290,
      1,
      NULL,
      2,
      1.417967,
      1,
      0.253586,
      1.778838,
      3.780301,
      NULL,
      3,
      0.678753,
      0.093408,
      0.949977,
      1.764553,
      2.489337,
      0,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0,
      3.505974,
      0,
      0.076982,
      1.558729,
      1.095171,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.693555,
      1.770921,
      0.176991,
      1.931853,
      0,
      1.288067,
      3,
      NULL,
      0,
      0,
      0,
      0.558779,
      NULL,
      NULL,
      1.524007,
      0.248750,
      1.505172,
      0.321684,
      NULL,
      NULL,
      2.131789,
      0.941479,
      NULL,
      NULL,
      3.130012,
      2.882548,
      1.660004,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      1.467668,
      0,
      1.951521,
      0.163103,
      0,
      1.719090,
      NULL,
      '',
      NULL);
commit;
end;
/


