set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7426050';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4334224',
      0.556290,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.578708,
      2,
      1.504887,
      0,
      1.036541,
      1.690503,
      1,
      0,
      0.014846,
      2,
      1,
      1.714611,
      3.961559,
      1.636528,
      1,
      0,
      0.267794,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      0.439506,
      NULL,
      NULL,
      0.135375,
      NULL,
      0.265996,
      1.890122,
      NULL,
      2,
      2,
      1.069524,
      0,
      3,
      1.601293,
      2.464119,
      0,
      2.204039,
      NULL,
      NULL,
      0.571002,
      NULL,
      0,
      1.162183,
      1.117701,
      NULL,
      0.018972,
      0.432779,
      NULL,
      NULL,
      NULL,
      1.040118,
      1.429644,
      1,
      0.113125,
      3.587377,
      1.983449,
      0.227710,
      NULL,
      NULL,
      3.399644,
      NULL,
      NULL,
      0,
      NULL,
      0.642870,
      0.282825,
      0,
      1,
      0,
      NULL,
      0.670430,
      1.026512,
      NULL,
      1,
      0.572545,
      0,
      1.724013,
      0.486161,
      NULL,
      2,
      NULL,
      1,
      0,
      0,
      NULL,
      3.876035,
      3.121303,
      1,
      NULL,
      1.918297,
      0.794375,
      3,
      NULL,
      '',
      '',
      ' 5-13-1987');
commit;
end;
/


