set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000100';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2400103',
      3.874259,
      NULL,
      NULL,
      NULL,
      2.420033,
      0.146470,
      NULL,
      9.936292,
      2.009167,
      1.314525,
      1,
      0.743563,
      NULL,
      2.247681,
      NULL,
      0.910319,
      0.065324,
      3,
      0,
      NULL,
      1,
      3.127444,
      1,
      NULL,
      0.707304,
      1,
      0.809081,
      1,
      0,
      NULL,
      0,
      NULL,
      1.976046,
      1,
      1,
      0,
      0.088157,
      NULL,
      1.472732,
      2.203410,
      1,
      1.881563,
      0.960803,
      NULL,
      1,
      0.246117,
      0.984629,
      1,
      1.562089,
      2,
      0,
      0.919718,
      0,
      1.130428,
      0.329704,
      0.809914,
      1.624496,
      NULL,
      3,
      3.438169,
      1.342050,
      NULL,
      0,
      0.567506,
      NULL,
      0,
      0,
      0,
      1,
      0.758929,
      1.709104,
      NULL,
      1.154854,
      NULL,
      0.916322,
      1,
      0,
      0,
      0,
      NULL,
      0,
      1.346316,
      NULL,
      0,
      1.450202,
      NULL,
      1.040999,
      2.652011,
      NULL,
      NULL,
      2.832147,
      1.258767,
      2.882712,
      3,
      NULL,
      1.838786,
      1,
      1.133566,
      0,
      0,
      0.973064,
      0,
      1.819658,
      0,
      25,
      1,
      '',
      '',
      NULL);
commit;
end;
/


