set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6917568';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2330440',
      2,
      0,
      10.054993,
      1.786914,
      0.454213,
      NULL,
      NULL,
      28.502989,
      1.465164,
      1,
      2.723730,
      1,
      2.825086,
      NULL,
      0,
      3,
      1,
      0.010737,
      1,
      1,
      NULL,
      0.618518,
      1.313379,
      0.616615,
      1,
      3,
      NULL,
      1.578171,
      0.961262,
      1.399378,
      1.197404,
      2.042627,
      0.954545,
      0.861318,
      NULL,
      2.859089,
      NULL,
      1,
      0.963865,
      3,
      NULL,
      0.650183,
      1.474990,
      2,
      0,
      3.786350,
      1,
      0.089811,
      0,
      0.813287,
      1.588935,
      1.434308,
      0,
      0,
      0.354361,
      1.978936,
      1.751208,
      3.614071,
      0.360891,
      NULL,
      0,
      0,
      NULL,
      0.285317,
      NULL,
      0.766208,
      0,
      NULL,
      0,
      1.864998,
      1.123569,
      1,
      1,
      0.558460,
      1,
      3,
      0.318169,
      NULL,
      0.359226,
      0,
      NULL,
      0.831176,
      1,
      1.898041,
      1.804641,
      2.637184,
      0.936013,
      0.782919,
      1.051247,
      1.466648,
      0.312740,
      2,
      2,
      0.973827,
      NULL,
      1.964893,
      2,
      0.714533,
      3,
      3,
      NULL,
      0,
      1.869763,
      NULL,
      15.738052,
      3,
      '122',
      '24',
      ' 7-14-1988');
commit;
end;
/


