set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8221692';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1441034',
      3,
      3,
      17.289062,
      1,
      3,
      1,
      9.140798,
      12.975189,
      1,
      0,
      NULL,
      3.683999,
      1.636429,
      0,
      0,
      0.948031,
      0,
      NULL,
      3,
      NULL,
      0,
      3.620309,
      0.416867,
      0.520680,
      0,
      2,
      1.974504,
      1.094241,
      1,
      NULL,
      1.710155,
      1,
      1.339181,
      NULL,
      0.955046,
      0,
      NULL,
      0.764671,
      1,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1,
      1.117745,
      NULL,
      1,
      0,
      1,
      1.477323,
      1.004012,
      0,
      0,
      0.037898,
      0.506033,
      NULL,
      3,
      0,
      1.898305,
      NULL,
      NULL,
      0.473868,
      1,
      0.203148,
      0.760562,
      0,
      1,
      0.721236,
      0,
      0.278890,
      0,
      3.798532,
      2,
      0.725827,
      1,
      1.239304,
      NULL,
      1,
      3.592179,
      0.201078,
      0,
      1,
      0.157861,
      0.425864,
      1,
      NULL,
      0.851659,
      NULL,
      1.841876,
      0,
      2.063734,
      2,
      0,
      1.509284,
      1,
      2.800935,
      0.790680,
      2,
      NULL,
      1.619053,
      3.226043,
      0,
      1,
      25.149565,
      NULL,
      NULL,
      NULL,
      ' 6-15-1990');
commit;
end;
/


