set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7508247';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3313434',
      1.725372,
      3,
      10,
      1.751388,
      0,
      NULL,
      NULL,
      26,
      0,
      2,
      NULL,
      3,
      2,
      0.132862,
      2,
      0.158400,
      0.540472,
      0.750339,
      2.411072,
      0,
      0.024932,
      NULL,
      NULL,
      1.725433,
      NULL,
      0,
      1,
      0.932769,
      1.983516,
      0.566255,
      1,
      0,
      1,
      1.265301,
      NULL,
      NULL,
      0.177715,
      1.099540,
      1.433202,
      1.904997,
      3,
      2,
      1.222867,
      2,
      0.460012,
      2,
      NULL,
      1,
      1.204727,
      0,
      0,
      1,
      0.742294,
      1,
      1,
      1.131622,
      NULL,
      0.371524,
      0,
      0,
      0.263997,
      1,
      NULL,
      0.367672,
      1,
      NULL,
      1.563082,
      2.132660,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.405740,
      1,
      1.854272,
      0,
      0.526364,
      1.627066,
      1,
      0,
      0,
      1,
      NULL,
      0.623296,
      0.620783,
      NULL,
      2.576348,
      2.268031,
      3.433601,
      NULL,
      1.948355,
      1.161471,
      NULL,
      1,
      NULL,
      NULL,
      2.551414,
      3,
      0.739682,
      0.768608,
      NULL,
      15,
      2,
      '300',
      '313',
      NULL);
commit;
end;
/


