set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8623103';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3241300',
      2.507321,
      NULL,
      15.171957,
      2,
      1.219879,
      NULL,
      NULL,
      NULL,
      1.099446,
      3,
      1.332782,
      1.636336,
      NULL,
      NULL,
      3.848258,
      NULL,
      0,
      0.795422,
      NULL,
      NULL,
      0,
      3.774023,
      1.004854,
      NULL,
      0,
      1,
      1.107831,
      0.154832,
      1.042254,
      0.844484,
      1.069370,
      0,
      1,
      1,
      1.900502,
      NULL,
      1,
      0.109142,
      0.410346,
      3.995421,
      1,
      NULL,
      0.686318,
      0.521561,
      1.426145,
      1.591050,
      1.309109,
      1.528669,
      1,
      2,
      0,
      NULL,
      0.620600,
      1,
      0,
      NULL,
      1.257318,
      1.304118,
      0.362485,
      0.989265,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      1.210654,
      1.233249,
      0.426311,
      0.556740,
      1,
      NULL,
      1.615615,
      1,
      0,
      1,
      0,
      1.958204,
      1,
      1.642282,
      1.696927,
      0.493496,
      NULL,
      0.162022,
      1.202111,
      0,
      1,
      0,
      0.348323,
      0,
      0,
      3.816220,
      1.099319,
      0,
      NULL,
      0,
      0.733188,
      0,
      2.001553,
      1.672551,
      3.974102,
      3,
      1.036269,
      0,
      6.831944,
      4,
      '',
      NULL,
      ' 1- 7-1978');
commit;
end;
/


