set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000258';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2310141',
      1.472901,
      0,
      10.673248,
      NULL,
      3.738260,
      3,
      62,
      62,
      NULL,
      2,
      2.992647,
      1.069372,
      3.340262,
      0,
      2,
      1.753418,
      NULL,
      1.219981,
      2.127300,
      1,
      1.220456,
      2,
      0.366892,
      1,
      1.618191,
      0,
      0,
      0.968348,
      1.719861,
      NULL,
      0,
      NULL,
      0.225513,
      0,
      0,
      2,
      0,
      NULL,
      0,
      2,
      1.152544,
      2,
      3.146132,
      0.026875,
      0,
      NULL,
      0,
      0.907648,
      NULL,
      1,
      1.095024,
      1,
      1.941155,
      NULL,
      0,
      1,
      1,
      1,
      3,
      1.455812,
      0.678601,
      0.400713,
      0.305389,
      0,
      1,
      2,
      0.306893,
      1,
      1.044196,
      1,
      NULL,
      0,
      0.283087,
      0,
      1.260973,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      0.670377,
      0,
      0,
      0.444615,
      1,
      1.838905,
      1.166811,
      0.046312,
      1.404150,
      0,
      1,
      0.595481,
      1.978770,
      0,
      0.349745,
      0,
      0.410650,
      2.397329,
      1.635293,
      1,
      1.632920,
      NULL,
      0.197244,
      3.460019,
      4,
      '104',
      '021',
      NULL);
commit;
end;
/


