set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9115135';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0142200',
      2.931212,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      18,
      1,
      1,
      1,
      2,
      NULL,
      NULL,
      0.641897,
      3.035949,
      1.621220,
      1,
      NULL,
      0.192589,
      0.865100,
      3,
      0.377407,
      2,
      NULL,
      1.044422,
      NULL,
      0.312931,
      NULL,
      2,
      1,
      1,
      0.695915,
      NULL,
      1.766678,
      0,
      0,
      NULL,
      NULL,
      2,
      0,
      0.203010,
      2.477003,
      NULL,
      0,
      NULL,
      0.359879,
      3.317203,
      1.821343,
      1,
      NULL,
      1.358063,
      NULL,
      1,
      1.868063,
      NULL,
      1.733380,
      NULL,
      0,
      3.525237,
      1.425251,
      0,
      0,
      1,
      1,
      0,
      0.308357,
      3.764765,
      0,
      0.239712,
      1.473259,
      1.845285,
      1.024147,
      NULL,
      1.332181,
      3,
      1.020354,
      0.612773,
      1.066404,
      1.982286,
      1.570908,
      NULL,
      1.993626,
      NULL,
      0.589311,
      NULL,
      1.371696,
      1.237944,
      0.572191,
      1.397795,
      NULL,
      1.898574,
      2.663344,
      0.341385,
      0.109082,
      0,
      NULL,
      1.477099,
      1.763816,
      2,
      0,
      3,
      0,
      1.908300,
      6.568264,
      NULL,
      '',
      NULL,
      ' 2- 3-1981');
commit;
end;
/


