set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9233337';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3024020',
      0,
      1,
      34.302369,
      NULL,
      NULL,
      NULL,
      NULL,
      49.324656,
      NULL,
      0.401013,
      0,
      0.016343,
      1,
      0,
      NULL,
      1.620977,
      0.114087,
      NULL,
      2.221188,
      3,
      1.975072,
      NULL,
      1,
      NULL,
      0.739269,
      2.474563,
      NULL,
      0.360742,
      1.485490,
      NULL,
      1.752075,
      3.215467,
      NULL,
      1,
      1.881456,
      0.786766,
      1.140234,
      NULL,
      1,
      1.062328,
      1.668501,
      1.313506,
      0.894505,
      0,
      NULL,
      1.562547,
      3,
      0,
      1.908912,
      3.684059,
      1,
      1,
      1,
      1.851127,
      2.524833,
      NULL,
      1,
      0.896622,
      1,
      NULL,
      1.184617,
      1,
      1.490254,
      NULL,
      0.789081,
      1.802985,
      0,
      1.998615,
      0,
      NULL,
      0,
      0.890085,
      2.684805,
      1.968035,
      NULL,
      0,
      1.637909,
      0.610495,
      0.918567,
      0,
      0.839293,
      0.223553,
      1,
      2.470177,
      NULL,
      NULL,
      0,
      0.749926,
      0.263073,
      0,
      0,
      1.214764,
      0,
      NULL,
      0.387035,
      1.427236,
      1,
      1.929583,
      0.411795,
      1.280714,
      NULL,
      3.620452,
      NULL,
      NULL,
      23.041131,
      1.927636,
      '333',
      '110',
      NULL);
commit;
end;
/


