set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000239';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4141203',
      NULL,
      NULL,
      NULL,
      2.297877,
      3.401310,
      4,
      56,
      39.671184,
      0.912863,
      3,
      NULL,
      2.425454,
      1,
      1,
      1.403551,
      2.148211,
      0,
      2,
      1.683486,
      NULL,
      0,
      0.122687,
      1,
      0,
      1.719983,
      0.331563,
      0.812570,
      0.277580,
      0,
      NULL,
      0.820814,
      0.627955,
      3,
      1.738365,
      1.660241,
      0,
      1.933884,
      0,
      1.607985,
      1.221700,
      1.008352,
      0.085744,
      0.241348,
      0.143975,
      NULL,
      1,
      2,
      0,
      0,
      0,
      1,
      0.362073,
      3,
      2,
      0,
      0.045893,
      0.575986,
      2,
      0,
      0.681049,
      0.938883,
      0.189424,
      1,
      NULL,
      0.694101,
      2,
      0.708773,
      1,
      0,
      3,
      NULL,
      2,
      2,
      NULL,
      0,
      1.847375,
      0.156664,
      0,
      0.306785,
      0,
      0.604219,
      1,
      1.560271,
      0.892321,
      3.445002,
      NULL,
      3.247701,
      NULL,
      1,
      3,
      1,
      NULL,
      0.782808,
      1,
      2,
      0.208442,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      0.623127,
      39.265455,
      19,
      '300',
      '444',
      ' 2- 8-1977');
commit;
end;
/


