set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9135795';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2,
      1,
      34,
      1,
      1.464831,
      NULL,
      NULL,
      5,
      0,
      2.542022,
      1,
      1.614694,
      3,
      0.450575,
      2,
      1,
      0.141897,
      0,
      0,
      NULL,
      0.019013,
      3,
      0,
      2,
      1,
      NULL,
      0.789663,
      1.850337,
      0.405394,
      NULL,
      1.945537,
      0,
      1,
      0.066650,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      3.009470,
      1,
      1.899014,
      NULL,
      1,
      0,
      1.101495,
      NULL,
      0,
      1,
      1.419099,
      0,
      3.627317,
      1,
      0.629718,
      0,
      2.009481,
      3.689496,
      1.971470,
      1.749643,
      0.155378,
      0.076944,
      1,
      0.518995,
      1.495495,
      1.632087,
      1,
      1.626877,
      1,
      0,
      NULL,
      3.246282,
      1.926883,
      1,
      NULL,
      1.373025,
      0,
      0.789899,
      1.844337,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.431831,
      1,
      3,
      2.659762,
      NULL,
      NULL,
      1.095786,
      NULL,
      3,
      1.090268,
      0,
      1.324733,
      2.528008,
      0,
      1,
      8,
      NULL,
      '412',
      '32',
      '11- 5-1995');
commit;
end;
/


