set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4403805';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      1.173648,
      NULL,
      15,
      2.436092,
      1.587452,
      5.875093,
      23,
      21.917674,
      0.458278,
      NULL,
      0.240473,
      0.162677,
      0.756295,
      0,
      NULL,
      NULL,
      0.468646,
      NULL,
      NULL,
      NULL,
      0,
      0.817907,
      1,
      NULL,
      0,
      0,
      0.736571,
      0,
      0,
      0.562482,
      0.230409,
      0.864152,
      3.265453,
      1,
      NULL,
      0.110385,
      0,
      1,
      0,
      NULL,
      0.774963,
      1.382609,
      0.929782,
      NULL,
      0.760436,
      2.237178,
      NULL,
      NULL,
      0.073767,
      NULL,
      1.553138,
      1.025506,
      0.637991,
      0,
      0.082031,
      0.595770,
      NULL,
      2,
      NULL,
      0,
      1,
      1,
      0,
      0.178664,
      NULL,
      2,
      1,
      1.398056,
      1.295573,
      NULL,
      0.358003,
      1,
      1,
      3,
      1,
      3,
      1,
      NULL,
      1.929539,
      0,
      1.367497,
      NULL,
      NULL,
      0.883502,
      0.547396,
      NULL,
      0,
      3,
      0,
      1,
      0,
      0,
      1,
      0,
      1.660663,
      3.341622,
      1.243874,
      0,
      0,
      1.623742,
      1.803884,
      NULL,
      0.046784,
      NULL,
      NULL,
      3.501832,
      '',
      '',
      ' 3-10-1999');
commit;
end;
/


