set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9323773';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2022033',
      2,
      3,
      34,
      2,
      0.765217,
      NULL,
      NULL,
      NULL,
      1.775455,
      0,
      1,
      0.978769,
      3.415133,
      0.396336,
      3.236748,
      3.883849,
      1.698729,
      0,
      1,
      1.378750,
      3.077699,
      NULL,
      2,
      3,
      0.961862,
      2.985942,
      2.209253,
      1,
      1.491270,
      1,
      NULL,
      1.155088,
      0,
      1,
      NULL,
      0,
      2.956512,
      NULL,
      NULL,
      NULL,
      1.435403,
      3.210372,
      0,
      2,
      0,
      0.910157,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.179990,
      3,
      NULL,
      3,
      1.873687,
      NULL,
      0,
      0.023983,
      NULL,
      NULL,
      1,
      1.245144,
      1,
      0.137836,
      NULL,
      NULL,
      1,
      2.624994,
      0.374891,
      1.223017,
      NULL,
      1,
      0.144296,
      NULL,
      3,
      2.604547,
      0.743906,
      2.223701,
      1,
      1.447578,
      NULL,
      NULL,
      1.663731,
      NULL,
      0.550153,
      0,
      0,
      1.636098,
      1,
      0.871404,
      3.478865,
      1.800823,
      0.841715,
      NULL,
      1,
      0.320693,
      1.121769,
      3.172412,
      3.592433,
      2.588186,
      NULL,
      3.511345,
      NULL,
      3.502597,
      16,
      NULL,
      '104',
      NULL);
commit;
end;
/


