set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8826569';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4313043',
      NULL,
      0,
      22.518376,
      1,
      2,
      NULL,
      6.920831,
      4,
      0.702857,
      1,
      0.301916,
      NULL,
      1.808358,
      NULL,
      NULL,
      3.182045,
      0.598956,
      NULL,
      NULL,
      0.152802,
      1,
      2,
      1.128856,
      NULL,
      1.990572,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.310016,
      2.721773,
      0,
      0,
      NULL,
      0.163511,
      1.451521,
      1,
      3,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0.293075,
      NULL,
      1,
      1,
      1,
      1.263660,
      0,
      0.194039,
      1,
      1.547283,
      NULL,
      1.630683,
      0,
      1.620611,
      NULL,
      0,
      NULL,
      3.874870,
      1.404668,
      1.904025,
      NULL,
      1,
      1.891795,
      NULL,
      NULL,
      2.505165,
      NULL,
      3.959379,
      NULL,
      1,
      0.420750,
      1.667676,
      0,
      0,
      1,
      0,
      1,
      2.066161,
      1,
      NULL,
      1.513372,
      1,
      1,
      3,
      2.141707,
      1.512881,
      0.028987,
      0.140695,
      3.877964,
      NULL,
      1.912928,
      3.489783,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      '',
      '',
      ' 5-11-1980');
commit;
end;
/


