set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000247';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0044032',
      2,
      3,
      9,
      1.929141,
      NULL,
      5,
      NULL,
      85,
      0,
      0,
      3,
      0,
      0.140239,
      0.086346,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0,
      2.081572,
      0,
      3.365893,
      1.785371,
      2,
      0,
      1.050754,
      1.125963,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.719140,
      0.389918,
      0,
      0,
      0.264067,
      1,
      2.652911,
      NULL,
      1,
      1.913117,
      NULL,
      1,
      0,
      0,
      2.039941,
      1.563696,
      0.624117,
      NULL,
      0.823577,
      0.788728,
      1,
      1,
      NULL,
      NULL,
      1.165762,
      1.398628,
      1.551467,
      0.419184,
      1,
      1.737737,
      3.357921,
      0.571934,
      NULL,
      1,
      NULL,
      1.991405,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      1.490668,
      1.541850,
      NULL,
      1,
      0,
      0,
      0,
      0.515427,
      1.266655,
      1,
      1,
      NULL,
      1.190229,
      NULL,
      1.414063,
      0,
      0,
      NULL,
      NULL,
      2.369933,
      1.953751,
      2.897540,
      1,
      2.898990,
      1.224049,
      0,
      NULL,
      0.337372,
      0.655795,
      NULL,
      NULL,
      ' 8-22-1981');
commit;
end;
/


