set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9119898';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      3,
      27.329420,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.804091,
      NULL,
      1,
      0.468787,
      0.414206,
      1.468233,
      3,
      NULL,
      NULL,
      0.548095,
      3.404249,
      0,
      0,
      0,
      1.390489,
      1.682503,
      1,
      0,
      2,
      1.974927,
      1,
      1.163638,
      1,
      NULL,
      1,
      0.451777,
      0,
      NULL,
      NULL,
      0,
      1,
      2.896060,
      NULL,
      0,
      0,
      NULL,
      0,
      1.957159,
      0,
      NULL,
      1.193693,
      2.723986,
      0.737940,
      1,
      1,
      0,
      3,
      1,
      NULL,
      0,
      0.930793,
      3,
      1.155313,
      NULL,
      0.686800,
      1.786499,
      NULL,
      0.239876,
      NULL,
      3.101186,
      NULL,
      0,
      1,
      1.334579,
      1,
      3,
      0.112314,
      0,
      0,
      0,
      1,
      1.394200,
      1.344245,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.427601,
      1.284190,
      1,
      0.401814,
      1.558522,
      NULL,
      2.059473,
      0,
      1,
      0,
      2,
      0,
      0.461990,
      0.656013,
      2.076602,
      0,
      3.647236,
      0.802191,
      9,
      7.711496,
      NULL,
      '',
      ' 7-11-1980');
commit;
end;
/


